// VERSION: Scilab: 5.4.1 
// OS: windows 7 
// CAPTION: PROGRAM TO FIND N-POINT DFT OF THE GIVEN SEQUENCE
clc;
clear;
close;
N=input('Enter the value of N='); //n-point
x=input('Enter the input sequence x(n)=');
subplot(3,2,1);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(x);
title('Input sequence');
xlabel('Samples n');
ylabel('Amplitude');

//calculation of DFT
for k=1:N
    y(k)=0;
    for n=1:N
        y(k)=y(k)+x(n).*exp(-%i*2*%pi*(k-1)*(n-1)/N);
        A=real(y);
        B=imag(y);
    end
end
mag=abs(y);
x1=atan(imag(y),real(y));
phase=x1*(180/%pi);
disp('The output DFT sequence is:');
disp(y);
subplot(3,2,2);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(y);
title('Output DFT sequence');
xlabel('Samples n');
ylabel('Amplitude');

//REAL VALUE
disp('The resultant real value is:');
disp(A);
subplot(3,2,3);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(A);
title('Real Value');
xlabel('Samples n');
ylabel('Amplitude');

//IMAGINARY VALUE
disp('The resultant imaginary value is:');
disp(B);
subplot(3,2,4);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(B);
title('Imaginary Value');
xlabel('Samples n');
ylabel('Amplitude');

//MAGNITUDE RESPONSE
disp('The Magnitude response is:');
disp(mag);
subplot(3,2,5);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(mag);
title('Magnitude Response');
xlabel('Samples n');
ylabel('Amplitude');

//PHASE RESPONSE
disp('The Phase response is:');
disp(phase);
subplot(3,2,6);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(phase);
title('Phase Response');
xlabel('Samples n');
ylabel('Phase');


  
//INPUT:
//Enter the value of N=4
//Enter the input sequence x(n)=[1 2 3 4]
 
//OUTPUT: 
//The output DFT sequence is:   
 
   // 10.              
  //- 2. + 2.i         
  //- 2. - 9.797D-16i  
  //- 2. - 2.i         
 
 //The resultant real value is:   
 
   // 10.  
  //- 2.   
  //- 2.   
  //- 2.   
 
 //The resultant imaginary value is:   
 
   // 0.         
   // 2.         
  //- 9.797D-16  
  //- 2.         
 
 //The Magnitude response is:   
 
    // 10.        
    //2.8284271  
    //2.         
    //2.8284271  
 
 //The Phase response is:   
 
   //  0.    
  //  135.  
  //- 180.  
 // - 135.
